<?php

use App\Http\Controllers\ClientAccountController;
use App\Http\Controllers\ClientInvoiceController;
use App\Http\Controllers\CollectionActionCodeController;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\DebtTypeController;
use App\Http\Controllers\DueController;
use App\Http\Controllers\EmailTemplateController;
use App\Http\Controllers\FieldController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\FixedReportController;
use App\Http\Controllers\FollowController;
use App\Http\Controllers\GroupController;
use App\Http\Controllers\InvoiceStatusCodeController;
use App\Http\Controllers\MailController;
use App\Http\Controllers\NoteController;
use App\Http\Controllers\PaymentAdjustmentController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\SolicitorController;
use App\Http\Controllers\UserController;
use App\Models\CollectionActionCode;
use App\Models\DebtType;
use App\Http\Controllers\CalendarController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\DebtorController;
use App\Http\Controllers\DebtorInvoiceController;
use App\Http\Controllers\HomeController;
use App\Models\InvoiceStatusCode;
use App\Models\Calendar;
use App\Models\Client;
use App\Models\Config;
use App\Models\Debtor;
use App\Models\EmailTemplate;
use App\Models\Report;
use App\Models\Solicitor;
use App\Models\Note;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/', function () {
//    return view('welcome');
//});
//
//Route::get('/dashboard', function () {
//    return view('dashboard');
//})->middleware(['auth'])->name('dashboard');

require __DIR__.'/auth.php';


Route::bind('client',function ($id){
    return Client::find($id);
});
Route::bind('debtor',function ($id){
    return Debtor::find($id);
});


Route::bind('config', function($id) {
    return Config::find($id);
});

Route::bind('solicitor', function($id) {
    return Solicitor::find($id);
});

Route::bind('collectionActionCode', function($id) {
    return CollectionActionCode::find($id);
});
Route::bind('invoiceStatusCode', function($id) {
    return InvoiceStatusCode::find($id);
});

Route::bind('debtType', function($id) {
    return DebtType::find($id);
});
Route::bind('report', function($id) {
    return Report::find($id);
});

Route::bind('emailTemplate', function($id) {
    return EmailTemplate::find($id);
});

Route::bind('note', function($id) {
    return note::find($id);
});
Route::bind('calendar', function($id) {
    return Calendar::find($id);
});

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth'])->name('dashboard');

require __DIR__.'/auth.php';

Route::middleware('auth')->group(function (){
    Route::resource('home',HomeController::class);
    Route::get('/', [HomeController::class, 'index'])->name('home.index');

    Route::post('home/openingBlance/payment/{month}/{year}/payment', [HomeController::class,'openingBalanceStore' ])->name('client.openingBalance.payment');
    /**
     * User
     */
    Route::resource('user',UserController::class);
    Route::get('user/{id}/delete', [UserController::class,'delete' ])->name('user.delete');


    Route::get('action/debtorInvoice/followup', [FollowController::class,'mainFollowUp' ])->name('debtorInvoice.mainFollow');

    Route::get('payment/debtorInvoice', [PaymentController::class,'mainPayment'])->name( 'debtorInvoice.mainPayment');

    //END

    /**
     * Config
     */
    Route::resource('config',ConfigController::class);
    Route::get('config/{id}/delete', [ConfigController::class,'delete' ])->name('config.delete');
    //END

    /**
     * Email Template
     */
    Route::resource('emailTemplate',EmailTemplateController::class);
    Route::prefix('emailTemplate')->Group(function(){
//      Route::get('{emailTemplate}', [ConfigController::class,'index' ])->name('emailTemplate.index');
        Route::get('{emailTemplate}/delete', [EmailTemplateController::class,'destroy' ])->name('emailTemplate.delete');
        Route::get('{emailTemplate}/edit', [EmailTemplateController::class,'edit'])->name( 'emailTemplate.edit');
        Route::patch('{emailTemplate}/update', [EmailTemplateController::class,'update' ])->name('emailTemplate.update');
    });
    //END


    /**
     *
     * import
     */
 //   Route::post('file/{file}/import', [FileController::class,'import' ])->name('file.import');
    Route::post('file/import/{clientId?}', [FileController::class,'import' ])->name('file.import'); // Modified by ranesh@radus28.com
    Route::get('import', [FileController::class,'index' ])->name('import.index');
    Route::get('import/{import}/debtorInvoice', [ FileController::class,'debtorInvoice'])->name('import.debtorInvoice');


    /**
     * Client rout group start.
     */
    //
    // Route::resource('magtration', MagtrationController::class);
    //

    Route::get('client/account', [ClientAccountController::class,'index' ])->name('client.account.index');
    Route::post('client/account/store', [ClientAccountController::class,'store' ])->name('client.account.store');
    Route::get('client/import', [ClientController::class,'import'])->name('client.import');
    Route::resource('client', ClientController::class);
    Route::post('client/export', [ClientController::class,'export' ])->name('client.export');

    Route::prefix('client')->middleware('client')->group(function (){

        // dd($router);
        Route::get('{client}/import', [ClientController::class,'import'])->name('client.import');
        Route::post('{client}/note', [NoteController::class,'store' ])->name('client.note.store');
        Route::post('{client}/debtor/{debtor}/note', [NoteController::class,'store' ])->name('client.debtor.note.store');
        Route::post('{client}/debtor/invoice/{invoiceId}/note', [NoteController::class,'store' ])->name('client.debtor.invoice.note.store');


        Route::get('/{client}/call/create', [CalendarController::class,'create' ])->name('calendar.call.client.create');
        Route::get('/{client}/todo/create', [CalendarController::class,'create' ])->name('calendar.todo.client.create');
        Route::post('/{client}/call/store', [CalendarController::class,'store' ])->name('calendar.call.client.store');
        Route::post('/{client}/todo/store', [CalendarController::class,'store' ])->name('calendar.todo.client.store');

        Route::get('/{client}/debtor/{debtor}/call/create', [CalendarController::class,'create' ])->name('calendar.call.client.debtor.create');
        Route::get('/{client}/debtor/{debtor}/todo/create', [CalendarController::class,'create' ])->name('calendar.todo.client.debtor.create');
        Route::post('/{client}/debtor/{debtor}/call/store', [CalendarController::class,'store' ])->name('calendar.call.client.debtor.store');
        Route::post('/{client}/debtor/{debtor}/todo/store', [CalendarController::class,'store' ])->name('calendar.todo.client.debtor.store');


        // paymentAdjustment

        Route::get('/{client}/paymentAdjustment', [PaymentAdjustmentController::class,'index' ])->name('client.paymentAdjustment.index');
        Route::post('/{client}/paymentAdjustment/add', [PaymentAdjustmentController::class,'store' ])->name('client.paymentAdjustment.store');
        Route::get('/{client}/paymentAdjustment/create', [PaymentAdjustmentController::class,'create'])->name( 'client.paymentAdjustment.create');

        /**
         * Client rout start under the Client rout group
         */
        Route::get('/{client}/delete', [ClientController::class,'delete'])->name( 'client.delete');
        Route::get('/{client}/detail', [ClientController::class,'detail' ])->name('client.detail');
        Route::get('/{client}/debtor/invoice', [ClientController::class,'debtor' ])->name('client.debtor.invoice');

        //Client Invoice
        Route::get('/{client}/client/invoice', [ClientController::class,'invoice' ])->name('client.invoice');
        Route::get('/{client}/client/invoice/{invoiceId}/edit', [ClientInvoiceController::class,'edit' ])->name('client.invoice.edit');
        Route::patch('/{client}/invoice/{invoiceId}', [ClientInvoiceController::class,'update'])->name( 'client.invoice.update');
        Route::get('/{client}/client/invoice/{invoiceId}/transaction', [ClientInvoiceController::class,'transaction' ])->name('client.invoice.transaction');
        Route::post('/{client}/client/invoice/{invoiceId}/transaction/add', [ClientInvoiceController::class,'store' ])->name('client.invoice.transaction.add');

        Route::get('/{client}/clientInvoice/{month}/{year}', [ClientInvoiceController::class,'invoice' ])->name('debtor.client.invoice.statement');



        Route::post('/{client}/clientInvoice/payment/{month}/{year}/payment', [ClientInvoiceController::class,'storeDebtor' ])->name('client.clientInvoice.statement.payment');

        Route::get('/{client}/clientPayment/{month}/{year}', [ClientInvoiceController::class,'clienPayview' ])->name('client.invoice.payView');
        Route::post('/{client}/clientPayment/payment/{month}/{year}/payment', [ClientInvoiceController::class,'clientPayStore' ])->name('client.clientPayment.statement.payment');


//Client mail
        Route::get('/{client}/mail', [MailController::class,'index' ])->name('client.mail');
        Route::post('/{client}/mail', [MailController::class,'store' ])->name('client.mail.store');

        //END


        /**
         * Debtor rout start under the Client rout group
         */
        Route::get('/{client}/debtor', [DebtorController::class,'index'])->name('client.debtor');

        Route::delete('/{client}/debtor/{debtor}', [DebtorController::class,'destroy' ])->name('client.debtor.destroy');
        Route::get('/{client}/debtor/{debtor}/detail', [DebtorController::class,'show'])->name( 'client.debtor.show');
        Route::get('/{client}/debtor/{debtor}', [DebtorController::class,'show'])->name( 'client.debtor.show');
        Route::get('/{client}/debtor/{debtor}/edit', [DebtorController::class,'edit' ])->name('client.debtor.edit');
        Route::patch('/{client}/debtor/{debtor}', [DebtorController::class,'update' ])->name('client.debtor.update');

        // Debtor Invoice
//        Route::get('/{client}/debtor/invoice', [ClientController::class,'debtor' ])->name('client.debtor.invoice');
        Route::get('/{client}/debtor/invoice/create', [DebtorInvoiceController::class,'create'])->name('client.debtor.invoice.create');
        Route::post('/{client}/debtor/invoice', [DebtorInvoiceController::class,'store'])->name('client.debtor.invoice.store');



        Route::get('/{client}/debtor/invoice/{invoiceId}/edit', [DebtorInvoiceController::class,'edit' ])->name('client.debtor.invoice.edit');

        Route::get('/{client}/debtor/invoice/{invoiceId}/delete', [DebtorInvoiceController::class,'delete' ])->name('client.debtor.invoice.delete');

        Route::delete('/{client}/debtor/invoice/{invoiceId}/', [DebtorInvoiceController::class,'destroy' ])->name('client.debtor.invoice.destroy');

        Route::patch('/{client}/debtor/invoice/{invoiceId}', [DebtorInvoiceController::class,'update' ])->name('client.debtor.invoice.update');
        Route::get('/{client}/debtor/invoice/{debtor}', [DebtorController::class,'delete' ])->name('client.debtor.delete');
        Route::get('/{client}/debtor/invoice/{invoiceId}/show', [DebtorInvoiceController::class,'show'])->name( 'client.debtor.invoice.show');
        Route::get('/{client}/debtor/invoice/{invoiceId}/pdf', [DebtorInvoiceController::class,'pdf'])->name( 'client.debtor.invoice.pdf');
        Route::post('/{client}/debtor/invoice/{invoiceId}/pdfPost', [DebtorInvoiceController::class,'pdfPost' ])->name('client.debtor.invoice.pdfPost');


        Route::get('/{client}/client/invoice/{invoiceId}/pdf', [ClientInvoiceController::class,'pdf' ])->name('client.invoice.pdf');
        Route::post('/{client}/client/invoice/{invoiceId}/pdfPost', [ClientInvoiceController::class,'pdfPost' ])->name('client.invoice.pdfPost');

        Route::get('/{client}/client/invoice/{invoiceId}/show', [ClientInvoiceController::class,'detail' ])->name('client.invoice.detail');

        Route::get('/{client}/debtor/invoice/debtor/create', [DebtorController::class,'create' ])->name('client.debtor.create');
        Route::post('/{client}/debtor/invoice/debtor', [DebtorController::class,'store' ])->name('client.debtor.store');
        Route::post('/{client}/debtor/invoice/{invoiceId}', [DebtorInvoiceController::class,'mailstore' ])->name('client.debtor.invoice.mail.store');
        // Debtor Payment

        Route::get('/{client}/debtor/invoice/{invoiceId}/payment', [PaymentController::class,'index'])->name( 'client.debtor.invoice.payment');
        Route::get('/{client}/debtor/invoice/{invoiceId}/payment/create', [PaymentController::class,'create' ])->name('client.debtor.invoice.payment.create');
        Route::post('/{client}/debtor/invoice/{invoiceId}/payment', [PaymentController::class,'store' ])->name('client.debtor.invoice.payment.store');
        Route::get('/{client}/debtor/invoice/{invoiceId}/payment/edit', [PaymentController::class,'edit' ])->name('client.debtor.invoice.payment.edit');
        Route::get('/{client}/client/invoice/{invoiceId}/payment', [ClientInvoiceController::class,'payment' ])->name('client.invoice.payment');
        Route::get('{client}/invoice/{invoiceId}/payment/{paymentId}/edit', [PaymentController::class,'edit' ])->name('client.invoice.payment.edit');
        Route::get('{client}/invoice/{invoiceId}/payment/{paymentId}/email', [PaymentController::class,'send' ])->name('client.invoice.payment.email');
        Route::patch('{client}/invoice/{invoiceId}/payment/{paymentId}/update', [PaymentController::class,'update'])->name( 'client.invoice.payment.update');

        //
        // Invoice follow

        Route::get('/{client}/debtor/invoice/{invoiceId}/follow', [FollowController::class,'index' ])->name('client.debtor.invoice.follow');
        Route::get('/{client}/debtor/invoice/{invoiceId}/follow/create', [FollowController::class,'create' ])->name('client.debtor.invoice.follow.create');
        Route::post('/{client}/debtor/invoice/{invoiceId}/follow', [FollowController::class,'store'])->name( 'client.debtor.invoice.follow.store');
        Route::get('/{client}/debtor/invoice/{invoiceId}/follow/edit/{id}', [FollowController::class,'edit' ])->name('client.debtor.invoice.follow.edit');
        Route::patch('{client}/invoice/{invoiceId}/follow/{followId}/update', [FollowController::class,'update' ])->name('client.invoice.follow.update');
        Route::get('{client}/invoice/{invoiceId}/follow/{id}/delete', [FollowController::class,'delete' ])->name('client.invoice.follow.delete');

        Route::delete('{client}/invoice/{invoiceId}/follow/{id}/destroy', [FollowController::class,'destroy' ])->name('client.invoice.follow.destroy');

        Route::get('/{client}/debtor/invoice/{invoiceId}/follow/edit/{id}', [FollowController::class,'edit'])->name( 'client.debtor.invoice.follow.edit');
        //
        // dues system
        Route::get('/{client}/debtor/invoice/{invoiceId}/Due', [DueController::class,'index' ])->name('client.debtor.invoice.due');
        // Route::get('/{client}/debtor/invoice/{invoiceId}/payment/create', [PaymentController::class,'create' ])->name('client.debtor.invoice.payment.create');
        Route::post('/{client}/debtor/invoice/{invoiceId}/due', [DueController::class,'store'])->name( 'client.debtor.invoice.due.store');

        // Debtor Mail
        Route::get('/{client}/debtor/{debtor}/mail', [MailController::class,'index' ])->name('client.debtor.mail');
        Route::post('/{client}/debtor/{debtor}mail', [MailController::class,'store' ])->name('client.debtor.mail.store');

        //END
    });
//END

    /**
     * User group
     */
    Route::resource('group',GroupController::class);
//END

    /**
     * Debtor rout group start.
     */
    Route::get('debtor/import', [DebtorController::class,'import' ])->name('debtor.import');
    Route::post('debtor/export', [DebtorController::class,'export' ])->name('debtor.export');
    Route::resource('debtor',DebtorController::class);
    Route::prefix('debtor')->middleware('debtor')->group(function (){

        /**
         * Debtor rout's start under the Debtor rout group
         */
        Route::get('debtor/{id}/delete', [DebtorController::class,'delete' ])->name('debtor.delete');

        // Debtor Invoice
        Route::get('/{debtor}/invoice', [DebtorController::class,'invoice' ])->name('debtor.invoice');
        Route::get('{debtor}/invoice/{id}', [DebtorInvoiceController::class,'edit' ])->name('debtor.invoice.edit');
        Route::get('{debtor}/invoice/{id}/show', [DebtorInvoiceController::class,'show' ])->name('debtor.invoice.show');
        Route::patch('/{debtor}/invoice/{invoiceId}', [DebtorInvoiceController::class,'update' ])->name('debtor.invoice.update');

        // Debtor Mail
        Route::get('/{debtor}/mail', [MailController::class,'index'])->name( 'debtor.mail');
        Route::post('/{debtor}/mail', [MailController::class,'store' ])->name('debtor.mail.store');

        //Debtor Payment
        Route::get('{debtor}/invoice/{invoiceId}/payment', [PaymentController::class,'index' ])->name('debtor.invoice.payment');

        //END

        Route::get('/{debtor}/call/create', [CalendarController::class,'create' ])->name('calendar.call.debtor.create');
        Route::get('/{debtor}/todo/create', [CalendarController::class,'create' ])->name('calendar.todo.debtor.create');
        Route::post('/{debtor}/call/store', [CalendarController::class,'store'])->name( 'calendar.call.debtor.store');
        Route::post('/{debtor}/todo/store', [CalendarController::class,'store' ])->name('calendar.todo.debtor.store');
        Route::post('{debtor}/note', [NoteController::class,'store' ])->name('debtor.note.store');
    });
//END

    /**
     * Debtor Payment rout group start.
     */
    Route::resource('payment',PaymentController::class);
    Route::prefix('debtor')->group(function (){
        Route::get('{payment}/invoice/{invoiceId}/edit', [PaymentController::class,'edit' ])->name('payment.edit');
        Route::patch('{payment}/invoice/{invoiceId}/update', [PaymentController::class,'update' ])->name('payment.update');
    });
//END

    /**
     * Debtor Invoice rout group start.
     */
    Route::resource('invoice',DebtorInvoiceController::class);
//END

    /**
     * Mail rout group start.
     */
    Route::get('mail', [MailController::class,'send' ])->name('mail.send');
    Route::get('mail/detail', [MailController::class,'index' ])->name('mail.index');
    Route::get('mail/inbox', [MailController::class,'incomeIndex' ])->name('mail.incomeIndex');
    Route::post('mail/{mail}/forward', [MailController::class,'forward' ])->name('mail.forward');
    Route::post('mail/{mail}/reply', [MailController::class,'reply'])->name( 'mail.reply');
    Route::get('mail/{mail}/print', [MailController::class,'printEmail'])->name('mail.print');
    Route::get('mail/{mail}', [MailController::class,'show' ])->name('mail.show');
    Route::post('mail', [MailController::class,'store' ])->name('mail.store');
//END

    /**
     * Profile rout group start.
     */
    Route::resource('profile',ProfileController::class);
//END

    /**
     * Solicitor rout group start.
     */
    Route::resource('solicitor',SolicitorController::class);
    Route::prefix('solicitor')->group(function (){
        Route::get('solicitor/{id}/delete', [ SolicitorController::class,'delete' ])->name('solicitor.delete');
    });
//END

    /**
     * collectionActionCode rout group start.
     */
    Route::resource('collectionActionCode',CollectionActionCodeController::class);
    Route::prefix('collectionActionCode')->group(function (){
        Route::get('collectionActionCode/{id}/delete', [ CollectionActionCodeController::class,'delete' ])->name('collectionActionCode.delete');
    });
//END

    /**
     * invoiceStatusCode rout group start.
     */
    Route::resource('invoiceStatusCode',InvoiceStatusCodeController::class);
    Route::prefix('invoiceStatusCode')->group(function (){
        Route::get('invoiceStatusCode/{id}/delete', [ InvoiceStatusCodeController::class,'delete' ])->name('invoiceStatusCode.delete');
    });
//END


    /**
     * debtType rout group start.
     */
    Route::resource('debtType',DebtTypeController::class);
    Route::prefix('debtType')->group(function (){
        Route::get('debtType/{id}/delete', [ DebtTypeController::class,'delete' ])->name('debtType.delete');
    });
//END
    Route::resource('model',ModelController::class);
    Route::resource('field',FieldController::class);

    /**
     * Report rout group start.
     */
    Route::resource('report',ReportController::class);
    Route::prefix('report')->group(function (){
        Route::get('report/{id}/delete', [ ReportController::class,'delete' ])->name('report.delete');
    });
//END

    /**
     * Fixed Report rout group start.
     */
    //Route::resource('fixed/report', 'FixedReportController');
    Route::get('fixed/report', [FixedReportController::class,'index' ])->name('fixed.report.index');
    Route::get('fixed/report/{id}', [FixedReportController::class,'show'])->name( 'fixed.report.show');

//END

    /**
     * Calendar rout group start.
     */
    Route::resource('calendar',CalendarController::class);
    Route::prefix('calendar')->group(function (){
        Route::patch('{calendar}/store', [CalendarController::class,'store' ])->name('calendar.update');
        Route::get('/call/create', [CalendarController::class,'create'])->name( 'calendar.call.create');
        Route::post('/call/store', [CalendarController::class,'store' ])->name('calendar.call.store');
        Route::get('/todo/create', [CalendarController::class,'create' ])->name('calendar.todo.create');
        Route::post('/todo/store', [CalendarController::class,'store' ])->name('calendar.todo.store');
        Route::get('{calendar}/detail', [CalendarController::class,'detail' ])->name('calendar.detail');
        Route::get('{calendar}/edit', [CalendarController::class,'edit' ])->name('calendar.edit');
        Route::get('{calendar}/delete', [CalendarController::class,'delete' ])->name('calendar.delete');
    });
//END
    Route::get('magtration', [MagtrationController::class,'index' ])->name('magtration.index');
    Route::get('magtrationAdd', [MagtrationController::class,'add'])->name( 'magtration.index1');
//});

//Route::get('magtrationAddCron', [MagtrationController::class,'add' ])->name('magtration.index.cron');







});



